# Bot-downloader
## Бот для скачивания видео с платформ с использованием утилиты yt-dlp и распределением работы с помощью RabbitMQ.

### Бот может скачивать и присылать видео длительностью 1-2 минуты с разрешением FullHD, 2-4 минуты с разрешением HD, 5-8 минут для разрешения 480p и 10 минут с разрешением ниже. Это связано с ограничением на размер присылаемых ботами файлов.

## Запуск бота на ПК
1. Установите postgres и создайте базу данных:
```
psql -U POSGTRES_USER -h POSTGRES_HOST
CREATE DATABASE POSTGRES_DATABASE;
```
2. Склонируйте репозиторий в удобную вам папку:
```
git clone https://github.com/m1likus/bot_downloader.git
```
3. Создайте файл `.env` и задайте там необходимые переменные окружения из `.env.example`
4. Перейдите в папку, в которой находится репозиторий. Запустите установку необходимых зависимостей:
```
./install.sh
```
5. Активируйте виртуальное окружение:
```
source .venv/bin/activate
```
6. Запустите бота:
```
./entrypoint.sh
```
Таким образом ваша база данных пересоздастся и бот запустится. Прежде, чем начинать работу с ботом, необходимо запустить хотя бы один consumer (скачиватель).

7. Откройте отдельный терминал, перейдите в папку, в которой находится репозиторий и запустите consumer:
```
python3 -m run_worker
```
8. Просмотр базы данных:
```
psql -h POSTGRES_HOST -U POSTGRES_USER -p POSTGRES_PORT -d POSTGRES_DATABASE
SELECT * FROM users;
SELECT * FROM telegram_updates ORDER BY id DESC limit 1;
```
Теперь вы можете начинать работу с ботом!

## Запуск бота в Docker
В Makefile доступно два варианта запуска бота:

1. С использованием `docker-compose.yml`
```
make compose_all_up
```
2. Без использования `docker-compose.yml`
```
make all_up
```


## Общая идея работы бота
1. Пользователь, который впервые запускает бота, может написать любое сообщение (/start, привет, и тд). В дальнейшем бот (если не будет пересоздания базы данных) запомнит пользователя и будет сразу проверять все сообщения как ссылки.
2. Пользователь присылает боту ссылку на видео или video-id (video-id работает только с платформой YouTube).
3. Бот получает ссылку, записывает ее в базу данных, и проверяет ссылку на валидность. В случае, если ссылка валидна, то получает информацию о видео, и предлагает пользователю выбрать разрешение.
4. Пользователь выбирает разрешение с помощью inline-клавиатуры. Бот записывает это в базу данных и предлагает выбрать пользователю тип видео.
5. Пользователь выбирает тип видео с помощью inline-клавиатуры. Бот записвыает это в базу данных и формирует задание на скачивание. Помещает это задание в очередь.
6. Consumer'ы слушают очередь, и как только задание оказывается в очереди, свободный consumer забирает себе это задание, скачивает видео и пересылает его пользователю.
7. Пользователь получает файл и может снова присылать ссылку боту.


## Техническая составляющая. Описание файлов.
### `__main__.py` - точка входа
`bot.long_polling` - модуль для работы с API Telegram с использованием техники Long Polling \
`Dispatcher` - класс, который распределяет входящие сообщения по обработчикам (хэндлерам) \
`get_handlers` - функция, которая возвращает все доступные хэндлеры \
`asyncio` - библиотека для асинхронного программирования 

Создаем `dispatcher`, определяем хэндеры и запускаем `long_polling`. Добавлена обработка прерывания по нажатию `Ctrl + C`

`asyncio.run(main())` - запуск асинхронной функции main

Асинхронность позволяет боту обрабатывать входящие сообщения одновременно от разных пользователей.

### `database_client.py` - работа с базой данных PostgreSQL
`os` - библиотека для работы с операционной системой. Используется для получения значений переменных окружения \
`json` - библиотека для работы с JSON форматом \
`bot.types` - модуль, в которой хранится `enum STATE`, который означает состояние пользователя \
`load_dotenv` - загружает переменные из `.env` файла \
`asyncpg` - библиотека для асинхронной работы с PostgreSQL 

`_pool` - глобальная переменная для пула соединений. Пул создается только один раз и переиспользуется. Максимальное число соединений: 10. \
`get_pool` - функция для создания пула соединений. Загружает из переменных окружения `POSTGRES_HOST`, `POSTGRES_PORT`, `POSTGRES_USER`, `POSTGRES_PASSWORD`, `POSTGRES_DATABASE`. Если какая-то из переменных не задана, то поднимает ошибку ValueError.
Если все переменные заданы, то создает и возвращает из функции соединение с базой данных. 

`close_pool` - закрывает пул соединений 

`create_database` - создает таблицы в базе данных. Базы данных: `telegram_updates` - хранит все сообщения от пользователей в формате json, `users` - хранит пользователей, которые когда-либо писали боту, их состояние, url видео, которое они хотят скачать, video_res - разрешение видео, которое они выбрали, и video_type - тип видео. \
`connection = await pool.acquire()` - берет одно соединение из пула. Если нет свободных, то ждет, пока освободится. Затем выполняется команда для базы данных с помощью `await connection.execute` \
Вызывать вручную `connection.close` не надо, так как после благодаря `with` оно вызывается автоматически.

`delete_database` - удаляет таблицы в базе данных 

`persist_updates` - сохраняет updates бота в базе данных в JSON-формате

`ensure_user_exists` - проверяет существование пользователя и создает, если пользователя еще нет в таблице users в базе данных.

`clear_user_video_and_set_state` - очищает все поля, связанные с видео пользователя и устанавливает state в `STATE.WAIT_FOR_ID`. Это сделано для того, чтобы пользователю больше не приходилось писать приветственные сообщения боту, а можно было сразу присылать url.

`update_user_state` - устанавливает state пользователя

`get_us er` - возвращает доступную из базы данных информацию про пользователя

`update_user_video` - устанавливает url выбранного пользователем видео

`update_user_video_res` - устанавливает video_res (разрешение) видео, выбранного пользователем

`update_user_video_type` - устанавливает video_type (со звуком/без звука/только видео)

### `dispatcher.py` - отвечает на вопрос: какой обработчик будет обрабатывать входящее сообщение?

Импортируются модули: `handler` - хранит в себе абстрактный класс `Handler`, `database_client` - для работы с базой данных, `STATUS` - enum, которая имеет два состояния: STOP И CONTINUE.

`init` - инициализируем класс Dispatcher, список всех обработчиков(хэндлеров) пока пустой

`add_handlers` - добавляем обработчики (хэндлеры)

`_get_telegram_id_from_update` - получаем telegram_id из сообщения пользователя

`dispatch`- метод обработки updates. Получаем ID пользователя, загружаем данные пользователя из БД и затем ищем подходящий хэндер для сообщения. STATUS.STOP означает, что дальнейшая обработка прекращается.

### `long_polling.py` - постоянно опрашивает сервер: сообщения есть? А если найду?

Импортируем модули `Dispatcher` - маршрутизатор для сообщений и `telegram_api_client` - работа с API Telegram.

`offset = 1` - смещение для обновлений \
`next_update_offset` - актуальное значение update_id. Telegram будет присылать updates только со значением update_id больше этого значения

Бот крутится в бесконечном цикле, и выход осуществляется только по прерыванию `Ctrl + C`

Получает обновления с помощью `await bot.telegram_api_client.get_updates(offset=next_update_offset)`, посылается запрос на сервер Telegram с помощью запроса getUpdates. 
Каждое update (обновление) обрабатывается с помощью dispatcher.

Для дополнительного логгирования в консоль выводится telegram_id пользователя, который написал боту. Параметр flush = True означает немедленный вывод в консоль.

### `recreate_database.py` - скрипт для очистки и пересоздания таблиц в базе данных

Импорт модуля работы с базой данных `database_client` и библиотке асинхронной работы `asyncio`

`delete_database` - удаляет таблицы telegram_updates и users  в базе данных, а `create_database` - снова их создает

### `telegram_api_client.py` - клиент для Telegram API

Импорт модулей: `json` - работа с JSON-форматом, `os` - работа с операционной системой (получение значений переменных окружения), `enum` - позволяет реализовать класс Enum, `load_dotenv` - загружает переменные окружения из файла `.env`, `aiohttp` - библиотека для асинхронной работы с HHTPs запросами, `aiofiles` - библиотек для асинхронной работой с файлами

`METHODS` - класс Enum с перечислением реализованных методов API (кроме `send_document`, потому что эта функция работает не с `make_request`)

`make_request` - общий метод для запросов. Создаем асинхронную HTTP сессию, выполняем post-запрос, парсим JSON-ответ и проверяем успешность, возвращаем только полезные данные

`get_me` - получение информации о боте

`get_updates` - получение обновлений (нужно для технологии long polling)

`send_message` - отправление сообщений в чат с chat_id

`send_document` - отправление файлов (особый случай). Использует не JSON формат, а multipart/form-data. Создаем асинхронную HTTP сессию, асинхронно читаем файл в память, rb - бинарный режим чтения, создаем форму данных (содержимое файла, имя файла, chat_id и подпись к файлу), отправляем POST-запрос, читаем ответ и проверяем успешность

`delete_message` - удаление сообщения с message_id в чате с chat_id

`edit_message_text` - позволяет редактировать сообщение с message_id в чате с chat_id

`answer_callback_query` - работа с inline-клавиатурой

### `types.py` - Enum's для комфортной работы
Хранит классы Enum. `STATUS` - возвращаемый хэндером статус обработки. STOP - остановить обработку, CONTINUE - продолжить обработку обновления дальше. `STATE` - статус пользователя:
 - `WAIT_FOR_ID` - бот ждет от пользователя ссылку на видео или video-id
 - `WAIT_FOR_RESOLUTION` - бот ждет, пока пользователь выберет разрешение видео
 - `WAIT_FOR_AUDIO` - бот ждет, пока ползователь выберет тип видео
 - `WAIT_FOR_START_DOWNLOADING` - задание помещено в очередь
 - `WAIT_FOR_DOWNLOAD` - задание скачивается

### `worker.py` - реализация consumer'ов (скачивателей, рабочих машин) - фоновой загрузки видео
Импорт модулей:
`json` - работа с JSON форматом, `yt_dlp` - утилита для скачивания видео, `os` - работа с операционной системой (для формирования пути для видео), `traceback` - улучшенное логирование ошибок, `aio_pika` - библиотека для асинхронной работы с RabbitMQ, `asyncio` - библиотека для асинхронного программирования, `telegram_api_client` - работа с API Telegram, `database_client` - работа с базой данных, `STATE` - статус пользователя

Класс `DownloadWorker` - слушает очередь сообщений RabbitMQ, скачивает видео по полученному из очереди заданию и отправляет скачанное видео пользователю.

`start_consuming` - метод работы с очередью RabbitMQ. Создает подключение: `connect_robust` - создает соединение с автоматическим переподключением. Подключение закрывается автоматически после блока with. Устанавливает канал связи и обрабатываем по одному сообщению за раз. Настраивает очередь. При перезапуске все сообщения сохраняются. В консоль выводит, что успешно запущен consumer. Далее обрабатывает в цикле сообщения с использованием асинхронного итератора очереди. `message.process` осуществляет автоматическое подтверждение обработки. Получает задание и декодируем его в JSON формат и запускает скачивание. Если что-то пошло не так, то выводит логи в консоль и очищает видео пользователя в базе данных, а состояние устанавливает в `WAIT_FOR_ID` (т.е. начинает весь процесс заново)


`process_download_task` - устанавливает состояние пользователя в `WAIT_FOR_DOWNLOAD` и запускает скачивание, а затем очищает видео пользователя и устаналивается состояние в первоначальное. Если что-то пошло не так, то отсылается пользователю сообщение об этом, и просит начать заново.

`_download_and_send_file` - скачивает видео пользователя. `event_loop` позволяет запускать синхронные функции в отдельных потоках. Функция `_donwload` не может быть асихнронной, так как представляет собой атомарную операцию скачивания. Создается директория `videos` для видео (если ее еще нет, а если уже есть, то параметр exist_ok = True позволяет не вызывать ошибку). С помощью утилиты `yt_dlp` видео скачивается по задания. `quiet` - выводит логи загрузки. `_download` запускается синхронно в отдельном потоке. По умолчанию используется ThreadPoolExecutor. Функция проверяет, что файл действительн скачался, отсылает его пользователю и удаляет. Ошибки обрабатываются и логируются.

## Хэндлеры:

### `__init__.py` - вот такие хэндлеры есть у бота
### `handler.py` - самый тут главный. Абстрактный класс. Остальные хэндлеры от него наследуются и реализуют его методы
### `UpdateDatabaseLogger` - первый среди равных
Обрабатывает абсолютно все входящие обновления и записывает их в базу данных. Возвращает `STATUS.CONTINUE` - значит обработку продолжаем.
### `EnsureUserExists` - второй среди равных
Обрабатывает все входящие обновления от пользователей. Убеждается, что пользователь уже есть в базе данных, а если его там нет, то добавляет. Возвращает `STATUS.CONTINUE` - значит обработку продолжаем.
### `MessageStart` - обрабатывает самое первое сообщение от пользователя
Когда пользователь впервые пишет боту, то его состояние в базе данных пустое. Поэтому хэндлер подхватывает сообщения пользователя и обрабатывает его: отправляет ответное сообщение с небольшим описанием работы бота. Важно: очищает inline-клавиатуру пользователя. Обновляет состояние пользователя до `WAIT_FOR_ID`. Возвращает `STATUS.STOP` - значит обработку останавливаем и ждем от пользователя ссылку или video-id.
### `UrlHandler` - ура, пришла ссылка! 
Импорт модулей: `telegram_api_client` - работа с API Telegram, `database_client` - работа с базой данных, `re` - библиотека работы с регулярными выражениями, `yt_dlp` - утилита для скачивания видео, `Handler` - реализуем абстрактный класс, `STATE, STATUS` - нужные Enum, `asyncio` - работа с асинхронным программированием.

Хэндлер говорит, что может обработать это сообщение, если состояние пользователя - ожидание ссылки, и если пользователь прислал какое-то сообщение. Сначала сообщение проверяется на наличие кириллицы в нем - это точно не ссылка. Затем запускатеся функция проверки ссылки `_process_user_input`. Если пользователь прислал не ссылку, то бот просит ввести ссылку или video-id. Если пользователь прислал ссылку, но она по какой-то причине нерабочая: пользователю возвращается сообщение о том, какая проблема с ссылкой возникла. Если предыдущие проверки прошли успешно, то у пользователя обновлятеся информация о видео и о состоянии в базе данных и бот получает список возможных разрешений видео и добавляет варианты в inline-клавиатуру, отправляет пользователю сообщение с inline-клавиатурой.

`_process_user_input` - обрабатывает ввод пользователя и говорит: ссылка это или video-id. Если video-id, то возвращает ссылку YouTube, которая соответствует видео с video_id.

`_is_video_id` - проверяет ли текст video-id с помощью регуларных выражений. video_id имеет длину 11 символов, это учитывается

`_is_url` - проверяет является ли текст ссылкой с помощью регулярных выражений

`_validate_video` - валидирует видео через yt_dlp. Асинхронная функция, выполняет синхронную функцию `extract_info` в отдельном потоке. Возвращает либо dict с информацией о видео, либо ошибку DownloadError, которая далее обрабатывается в `_get_user_friendly_error`

`_get_user_friendly_error` - возвращает пользователю понятное сообщение об ошибке

`_get_avaliable_resolution` - из yt_dlp получает возможные разрешения для данного видео. Асинхронная функция, выполняет синхронную функцию `extract_formats` в отдельном потоке. Возвращает 5 лучших разрешений видео, либо пустой dict

`_format_duration` - форматирует длительность видео в понятный пользователю вид

### `ResHandler` - обрабатывает нажатие пользователем клавиатуры
Получает желаемое разрешение видео от пользователя, редактирует предыдущее сообщение с inline-клавиатурой, заменяя старую клавиатуру на новую с выбором типа видео и обновляет состояние пользователя.

### `DownloadHandler` - мастер на все руки
Получает желаемый вид видео от пользователя и формирует задание на скачивание, добавляет его в очередь.

Хэндлер обрабатывает сообщение от пользователя, если была нажата кнопка на inline-клавиатуре и состояние пользователя установлено в `WAIT_FOR_AUDIO`

Сохраняет выбор пользователя насчет типа видео и обновляет состояние в `WAIT_FOR_START_DOWNLOADING`. Удаляет сообщение с inline-клавиатурой. Запускает процесс загрузки видео. Отвечает на callback запрос.

`_start_download_process` - начинает процесс скачивания: генерирует формат, создает задачу на скачивание и отправляет задачку в RabbitMQ. Если н получается, то отправляет сообщение пользователю об ошибке и просит начать заново. Устанавливает состояние пользователя в начальное.

`_generate_ydl_format` - генерирует ydl_format из разрешения + типа видео. Только аудио, либо только видео, либо видео+аудио до 720

`_send_to_rabbitmq` - отправляет задачку в очередь RabbitMQ. Асинхронная функция, различие с consumer'ом в том, что здесь происходит публикация сообщения с помощью обменника по умолчанию. Задание отправляется в формате JSON, и сообщения сохраняются на диск (одна очередь, прямая маршрутизация до consumer'ов). 

`_show_download_started` - показывает пользователю красивое сообщение о начале скачивания

--- 
## Бот проверен с помощью тестов и ручного тестирования. В связи с неработающим в России YouTube, бот пока не может обрабатывать видео с данной платформы. Тем не менее, если есть прокси-сервер, то в параметры yt_opts можно добавить параметр "proxy": proxy_ip и это позволит также скачивать видео и с YouTube