# Personal-Expense-Journal 💼💸

## 1. Зачем нужен бот

Быстрый способ фиксировать расходы прямо в Telegram и получать базовые отчёты:

* ✅ добавить покупку за несколько шагов;
* 📒 посмотреть последние записи;
* 📤 выгрузить CSV;
* ➕ узнать сумму последних 10 покупок.

> 💡 Идеи и предложения — создавайте в **Issues**.

---

## 2. Как работает бот (глазами пользователя)

### 2.1. Старт ▶️

Команда **/start**:

* Если базы ещё нет — бот предложит **Создать БД** (кнопка). После создания откроется меню.
* Если база уже есть — сразу откроется меню.

### 2.2. Главное меню (кнопки) 🧭

* **Добавить товар**
* **Последние (5–10)**
* **Получить БД (CSV)**
* **Сумма последних 10**
* **Справка**

### 2.3. Добавить товар — пошаговый диалог 🧾

1. **Категория**
   Бот покажет список по умолчанию (*Еда, Транспорт, Аптека, Дом, Одежда, Развлечения, Прочее*) и кнопку **➕ Другая…**.
   Можно выбрать готовую или добавить свою (ввести текстом).
   > Для каждого пользователя создается массив категорий, при добавлении новых категорий они попадфют в него. И добавляется кнопка выбора категории.

2. **Магазин**
   Список примеров (*Пятёрочка, Магнит, Аптека 36,6, Ozon, Wildberries, Лента, Прочее*) и **➕ Другой…**.
   Можно выбрать готовый или добавить свой.
   > Для каждого пользователя создается массив магазинов, при добавлении новых магизаинов они попадают в него. И добавляется кнопка выбора магазина.
3. **Сумма**
   Ввести число (`379.90` или `379,90`). Проверяем, что сумма **> 0**.

4. **Комментарий (опционально)**
   Короткий текст или пропуск.

5. **Подтверждение**
   Предпросмотр записи (дата, категория, магазин, сумма, комментарий). Кнопки: **Сохранить** / **Отмена**.
   На «Сохранить» бот отвечает «Готово ✅» и возвращает в меню.

### 2.4. Последние (5–10) 🕘

Показывает 5–10 последних записей: `дата · сумма · категория · магазин · (комментарий)`.
Кнопка **Показать ещё** — для следующей страницы.

### 2.5. Получить БД (CSV) 📄

Отправляет файл `expenses_YYYY-MM-DD.csv`.
Столбцы: `ts,category,store,amount,note`.

### 2.6. Сумма последних 10 ➕🔟

Считает сумму 10 последних записей (если меньше 10 — суммирует сколько есть) и пишет:
**«Сумма последних 10 операций: N ₽ (найдено M записей)».**

### 2.7. Получить отчет за месяц
Сумма всех расходов за выбранный месяц
Перечень категорий в которых была трата средств, сумма по каждой категории.

### 2.8. Справка ❓

Короткие подсказки по кнопкам и по формату суммы.

---

## 3. Команды, кнопки и состояния

**Команды:**

* `/start` — инициализация/меню
* `/help` — справка

**Кнопки (идея callback-значений):**

* `ADD_EXPENSE`, `LIST_RECENT`, `EXPORT_CSV`, `SUM_LAST10`, `HELP`
* внутри сценария: `CATEGORY_*`, `STORE_*`, `CUSTOM_CATEGORY`, `CUSTOM_STORE`, `CONFIRM_SAVE`, `CANCEL`

**Состояния шага «Добавить товар»:**
`IDLE → ASK_CATEGORY → ASK_STORE → ASK_AMOUNT → ASK_NOTE → CONFIRM → IDLE`

---

## 4. Данные (минимальная модель)

Одна таблица расходов (на пользователя):

* `user_id` — chat_id в Telegram
* `ts_utc` — дата/время покупки в UTC (ISO 8601)
* `category` — строка (категория/тип)
* `store` — строка (магазин/площадка)
* `amount` — число с точкой
* `note` — опциональный комментарий
* `created_at` — когда запись сохранена (UTC, ISO 8601)

---

## 5. Архитектура (просто и без кода)

Идея: разделить «как общаемся с Telegram» и «как ведём учёт расходов».

* **Transport (Telegram API)** — получить апдейты (long polling), отправить сообщение/файл.
* **Dispatcher/Router** — раздать событие нужному обработчику (по команде или текущему шагу диалога).
* **Handlers** — «тонкие» обработчики сценариев (Добавить товар, Последние, CSV, Сумма 10).
* **Service Layer** — бизнес-логика: проверка суммы, подготовка данных, подсчёты.
* **Repository** — работа с БД (CRUD) без SQL внутри сервисов.
* **Storage (SQLite)** — локальная база (индекс по `user_id, ts_utc`).

---

## 6. Требования и библиотеки 🧩

* **Python:** 3.11+ (лучше 3.12)
* **ОС:** Windows/WSL, Linux или macOS
* **База:** SQLite (встроена в Python — `sqlite3`), отдельный сервер не нужен

**Устанавливаем через `pip`:**

* `python-dotenv` — читать настройки из файла `.env`

> По мере необходимости сторонние зависимости будут добавляться.

**Стандартная библиотека (ничего ставить не нужно):**

* HTTP: `urllib.request`
* БД: `sqlite3`
* Логи: `logging`
* CSV: `csv`
* Дата/время: `datetime`

**Опционально (по желанию, для разработки):**

* `flake8` — проверка стиля/подсказки по коду

---

## 7. Быстрый старт (когда добавим код) 🚀

1. Клонировать репозиторий и зайти в папку проекта.
2. Создать виртуальное окружение и установить зависимости:

```bash
python -m venv .venv
# Linux/WSL/macOS:
source .venv/bin/activate
# Windows PowerShell:
# .\.venv\Scripts\Activate.ps1

pip install -r requirements.txt
```

3. Создать файл `.env` (на основе `.env.example`):

```env
BOT_TOKEN=PASTE_YOUR_TOKEN_HERE
DB_PATH=./data/expenses.db
LOG_LEVEL=INFO
```

4. Создать папку под базу:

```bash
mkdir -p data
```

5. Запуск (когда появится код):

```bash
python -m src
```

---

Если хочешь — добавлю мини-раздел с диаграммой Mermaid (поток обработки и FSM «Добавить товар») прямо в конец README, чтобы было наглядно.
