# Чат-бот «Планировщик»
---
# 1. Инструкция для пользователя (поведение бота глазами пользователя)

## Запуск и главное меню
1. Пользователь запускает бота `/start`.
2. Бот приветствует и показывает **основное меню** как reply-клавиатуру:
   - **➕ Добавить задачу**
   - **📅 Мои задачи**
   - **⚙️ Настройки**
   - **❓ Помощь**

## Первичные настройки
- Время утреннего дайджеста по умолчанию: **09:00** (MSK).
- Время вечернего напоминания по умолчанию: **21:00** (MSK).
- В `/settings` можно изменить **время утреннего дайджеста** и **время вечернего напоминания**.

## Создание задачи (`➕ Добавить задачу`)
1. Бот: "Напишите, что нужно сделать.
2. "Пользователь: (Отправляет текст, например, "Купить молоко").
3. Бот: "Отлично! На какой день?"
Inline-кнопки: [ Сегодня ] [ Завтра ] [ Без даты ]
(Примечание: Задачи "Без даты" — это "плавающие" задачи, которые будут показываться в утреннем дайджесте каждый день, пока не будут выполнены).
4. Пользователь: (Нажимает, например, [ Сегодня ]).
5. Бот: (Редактирует свое сообщение) 
"Хорошо. Укажите время (в формате ЧЧ:ММ) или нажмите 'Без времени', если это неважно.
"Inline-кнопка: [ ⏰ Без времени ]
 - Пользователь:Вариант А: Отправляет текстом время, например 14:30.
 - Вариант Б: Нажимает кнопку [ ⏰ Без времени ].
6. Бот: "Готово! Задача создана."Бот присылает "карточку" созданной задачи с кнопками управления.

## Просмотр задач (📅 Мои задачи)
1. Бот: "Показать задачи на:"
Inline-кнопки: [ 📍 Сегодня ] [ ➡️ Завтра ] [ 🗒️ Все 'Без даты' ]
2. Пользователь: (Нажимает одну из кнопок).
3. Бот: Если задачи есть: присылает список задач. Каждая задача — это отдельное сообщение с "карточкой".

Если задач нет: "Список пуст!". 
Особый случай: При просмотре [ ➡️ Завтра ], под списком задач будет доп. кнопка [ ➕ Добавить на завтра ] для быстрого создания.

## Карточки задач
Каждая активная задача отображается в виде "карточки" с inline-кнопками управления. Текст сообщения:

[14:30] Купить молоко (если времени нет: [Без времени] Купить молоко)

Кнопки (Уровень 1): [ ✅ Выполнить ] [ 🕑 Отложить ] [ ❌ Отменить ]

Нажатие [ ✅ Выполнить ]:Бот редактирует сообщение: [ ✅ ВЫПОЛНЕНО ] Купить молокоКнопки исчезают. Задача помечается как выполненная.

Нажатие [ ❌ Отменить ]:Бот редактирует сообщение: [ ❌ ОТМЕНЕНО ] Купить молокоКнопки исчезают. Задача помечается как отмененная.

Нажатие [ 🕑 Отложить ]:Бот редактирует кнопки (сообщение не меняется).

Кнопки (Уровень 2 - после "Отложить"): [ ✏️ Новое время (сегодня) ] [ ➡️ На завтра ] [ ↩️ Назад ]

Нажатие [ ✏️ Новое время (сегодня) ]:Бот присылает новое сообщение: "Введите новое время (ЧЧ:ММ) для задачи 'Купить молоко'."
Пользователь вводит время, бот обновляет задачу и редактирует оригинальную карточку задачи.

Нажатие [ ➡️ На завтра ]:Бот переносит задачу на завтра (время сбрасывается на "Без времени").Редактирует сообщение: [ ➡️ ПЕРЕНЕСЕНО НА ЗАВТРА ] Купить молоко. 
Кнопки исчезают.

Нажатие [ ↩️ Назад ]:Бот возвращает кнопки "Уровня 1".

 ## Настройки (⚙️ Настройки)
 1. Бот: "Здесь можно настроить уведомления.
 - Утренний дайджест: 09:00
 - Вечерний обзор: 21:00
 Inline-кнопки: [ ☀️ Изменить утро ] [ 🌙 Изменить вечер ]
 1. Пользователь: (Нажимает, например, [ ☀️ Изменить утро ]).
 2. Бот: "Введите новое время для утреннего дайджеста (ЧЧ:ММ). (Текущее: 09:00)"
 3. Пользователь: (Отправляет 08:00).
 4. Бот: "Готово! Утренний дайджест будет приходить в 08:00."

# Автоматические уведомления (По расписанию)
## Утренний дайджест (в 09:00 или в настроенное время)
1. Бот присылает сообщение: "Доброе утро! Задачи на сегодня:"
2. Далее бот присылает список "карточек" для всех задач, у которых: 

Дата = Сегодня, Дата = Без даты и статус = Активна.

## Уведомление по времени
Если у задачи Дата = Сегодня и Время = 14:30. Ровно в 14:30 бот присылает "карточку" этой задачи с текстом: "Напоминание о задаче:".
Пользователь может сразу ее выполнить/отложить/отменить.

## Вечерний обзор (в 21:00 или в настроенное время)
1. Бот присылает сообщение: 
"Вечерний обзор. Невыполненные задачи за сегодня:"Далее присылает список "карточек" для всех задач, у которых:( Дата = Сегодня или Дата = Без даты ) и статус = Активна.
2. Сразу после этого списка бот присылает отдельное сообщение:"
Задачи на сегодня, которые не были выполнены, автоматически переносятся на завтра (без времени).Хотите спланировать завтрашний день?
"Inline-кнопки: [ ➕ Добавить на завтра ] [ 📅 Посмотреть задачи на завтра ]

> Логика в фоне: В этот момент бот автоматически меняет у всех невыполненных задач с Дата = Сегодня -> Дата = Завтра и Время = null. Задачи "Без даты" остаются как есть.

---

## States
**MAIN_MENU** - возникает при /start или завершение диалога, состояние главного меню.

**WAIT_TASK_NAME** - возникает при нажатии [Добавить задачу], ожидает текст новой задачи.

**WAIT_TASK_DATE** -  введен текст задачи, ожидает день(сегодня, завтра) или нет.

**WAIT_TASK_TIME** - введен день выполнения, ожидает время (HH:MM) или нет.

**WAIT_POSTPONE_TIME** - возникает при нажатии Inline-кнопки [Сделаю сегодня] после откладывания задачи, ожидает новое время (HH:MM) для переноса активной задачи.

**WAIT_SETTING_MORNING** - возникает при нажатии Inline-кнопки [Изменить утро ], ожидает новое время (HH:MM) для утреннего дайджеста.

**WAIT_SETTING_EVENING** - возникает при нажатии Inline-кнопки [Изменить вечер ], ожидает новое время (HH:MM) для вечернего обзора.

## Handlers
**DatabaseLogger** - записывает входящий update в telegram_updates.

**EnsureUserExists** - проверяет/создает пользователя в users и user_settings (с дефолтными значениями).

**MessageStart** - очищает State пользователя. Отправляет приветствие и Reply-клавиатуру с основным меню.

**MessageAddTask** - устанавливает state = WAIT_TASK_NAME. Спрашивает название.

**TaskNameHandler** - сохраняет текст в название задачи. Устанавливает state = WAIT_TASK_TIME. запрашивает время для задачи.

**TaskTimeHandler** - валидирует время. Создает запись в таблице tasks. 

**TaskNoTimeHandler** - создает запись в tasks с task_time=NULL.

**MessageShowTask** - выполняет SELECT из tasks по дате/статусу. Отправляет список карточек с Inline-кнопками.

**MessageSettings** - показывает текущие настройки и кнопки [Изменить утро/вечер].

**PostponeTimeHandler** - валидирует и обновляет task_time и task_date (на сегодня) в таблице tasks.

**SettingsTimeHandler** - валидирует и обновляет user_settings(время ктреннего дайджеста и вечернего напоминания).

**CallbackQueryHandler** - обрабатывает: [Выполнить], [Отменить], [Потом], [Изменить утро/вечер].

## База Данных (SQLite) и Схема
 > Будет использоваться SQLite3, ее должно быть достаточно.
1. **users**

telegram_id - INTEGER(ID пользователя)

state - TEXT(Текущее состояние)

temp_task_data - TEXT(JSON-строка для временного хранения данных во время диалога)

2. **user_settings**

telegram_id - INTEGER(ID пользователя)

morning_digest_time - TEXT (HH:MM) (Время утреннего дайджеста )

evening_review_time - TEXT (HH:MM) (Время вечернего обзора)

3. **tasks**

id - INTEGER(ID задачи)

telegram_id - INTEGER(ID пользователя) 

text - TEXT(Текст задачи)

task_date - TEXT (YYYY-MM-DD) (Дата, на которую запланирована задача, или NULL)

task_time - TEXT (HH:MM) (Время уведомления, или NULL)

status - TEXT(Статус задачи: active, done, cancelled)

## Дополнительные библиотеки
**apscheduler** - обеспечивает выполнение функций по расписанию для отправки утреннего дайджеста и уведомлений по времени.

# Инструкция по использованию
1. Клонирование репозитория: 

git clone https://github.com/deademous/TodoListChatBot

2. Создать файл с переменными окружения:

cd TodoListChatBot

cat .env.example > .env

3. Ввести значения для переменных окружения.

4. Сборка проекта:

make build

5. Запуск контейнера с БД:

make postgres_run

6. Запуск контейнера с Телеграм ботом:

make run

7. Остановка контейнера с БД:

make postgres_stop

8. Остановка контейнера с Телеграм ботом:

make stop

# TelegramBot Deploy

1. С локального устройства собрать проект:

make build

2. С локального устройства выложить образ на DockerHub:

make push

3. На удаленном устройстве созать Makefile и файл с переменными окружения и отредактировть их:

touch Makefile .env

4. Залить образ на удаленное устройство:


docker pull (username on DockerHun)/tg_todolist_bot

5. Запуск контейнера с БД:

make postgres_run

6. Запуск контейнера с Телеграм ботом:

make run

7. Для просмотра логов контейнера с БД:

docker logs postgres_17

8. Для просмотра логов Телеграм бота:

docker logs todolist_bot