import json


def format_task_card_text(task: dict) -> str:

    status = task.get("status", "active")

    if task.get("task_time"):
        time_str = f"[{task['task_time']}]"
    else:
        time_str = "[Без времени]"

    text = task["text"]

    if status == "done":
        return f"✅ [ВЫПОЛНЕНО] {time_str} {text}"
    elif status == "canceled":
        return f"❌ [ОТМЕНЕНО] {time_str} {text}"

    return f"{time_str} {text}"


def get_task_card_reply_markup(task_id: int) -> str:

    return json.dumps(
        {
            "inline_keyboard": [
                [
                    {"text": "✅ Выполнить", "callback_data": f"task_done:{task_id}"},
                    {
                        "text": "🕑 Отложить",
                        "callback_data": f"task_postpone:{task_id}",
                    },
                    {"text": "❌ Отменить", "callback_data": f"task_cancel:{task_id}"},
                ]
            ]
        }
    )
